assert(load(assert(builder:open_text("setup_utility.lua"))))()
builder:set_default_size(30, 30)
import_for_setup("level_utility.lua", "advanced_level_utility.lua", "level_data.lua")
standard_setup({
  blocks = {"Red.png", "Blue.png"},
  main = {"advanced_level_utility.lua", "level_data.lua", "level_logic.lua"},
  info_panel = {
    {tab = "Goal", contents = {
      info_title("Specification"),
      low_level_figure({
        {object = interactions_for_source(get_spec(0)), width = 0.5, position = Vectord.new(-0.35, 0)},
        {image = "ArrowRight.png", width = 0.1, position = Vectord.new(0, 0)},
        {object = interactions_for_part(get_spec(0), 0), width = 0.5, position = Vectord.new(0.35, -0.15)},
        {object = interactions_for_part(get_spec(0), 1), width = 0.5, position = Vectord.new(0.35, 0.15)}
      }),
      info_desc([[The input on the left will produce a series of 8 x 5 compounds which are built from red and blue blocks. These will satisfy the following conditions:
     1. The top row of blocks will be blue.
     2. The bottom row of blocks will be red.
     3. Any two adjacent red blocks will be joined.
     4. Any two adjacent blue blocks will be joined.
     5. No blocks of different colors will be joined.
     6. There will only be one component of each color.
     7. Both components will have total height 4.
     8. The parts will not separate without portals.

     Separate these compounds into their two components.
     See Examples for more possible inputs.]])
    }},
    {tab = "Examples", contents = {
      info_title("Example Inputs"),
      low_level_figure({
        {object = interactions_for_source(get_spec(1)), width = 0.5, position = Vectord.new(-0.66, 0)},
        {object = interactions_for_source(get_spec(2)), width = 0.5, position = Vectord.new(0, 0)},
        {object = interactions_for_source(get_spec(3)), width = 0.5, position = Vectord.new(0.66, 0)},
        {object = interactions_for_source(get_spec(4)), width = 0.5, position = Vectord.new(-0.66, -0.4)},
        {object = interactions_for_source(get_spec(5)), width = 0.5, position = Vectord.new(0, -0.4)},
        {object = interactions_for_source(get_spec(6)), width = 0.5, position = Vectord.new(0.66, -0.4)},
        {object = interactions_for_source(get_spec(7)), width = 0.5, position = Vectord.new(-0.66, -0.8)},
        {object = interactions_for_source(get_spec(8)), width = 0.5, position = Vectord.new(0, -0.8)},
        {object = interactions_for_source(get_spec(9)), width = 0.5, position = Vectord.new(0.66, -0.8)},
        {object = interactions_for_source(get_spec(10)), width = 0.5, position = Vectord.new(-0.66, -1.2)},
        {object = interactions_for_source(get_spec(11)), width = 0.5, position = Vectord.new(0, -1.2)},
        {object = interactions_for_source(get_spec(12)), width = 0.5, position = Vectord.new(0.66, -1.2)}
      })
    }}
  },
  standard_resize = true
})
